<?php
/**
 * Unified Configuration File for ZForex Trading Platform
 * Combines database, mail system, and application settings
 */

// ================================
// DATABASE CONFIGURATION
// ================================
define("DB_HOST", "localhost");
define("DB_USER", "crmcentrioglobal_qfx-markets");
define("DB_PASS", "crmcentrioglobal_qfx-markets");
define("DB_NAME", "crmcentrioglobal_qfx-markets");

// Create mysqli connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}

// ================================
// MAIL SYSTEM CONFIGURATION
// ================================
define("MAIL_HOST", "smtpout.secureserver.net"); // Custom webmail SMTP host
define("MAIL_PORT", 465); // 465 for SSL (as specified)
define("MAIL_USERNAME", "support@qfx-markets.com"); // Support email address
define("MAIL_PASSWORD", "support@qfx-markets.com"); // Email password for webmail
define("MAIL_ENCRYPTION", "ssl"); // ssl for port 465
define("MAIL_FROM_EMAIL", "support@qfx-markets.com"); // From email address
define("MAIL_FROM_NAME", "QFXMarkets"); // From name

// ================================
// EMAIL TEMPLATE SETTINGS
// ================================
define('MAIL_LOGO_URL', 'https://qfx-markets.com/assets/images/logo.png');
define('MAIL_COMPANY_NAME', 'QFXMarkets');
define('MAIL_COMPANY_ADDRESS', 'Your Company Address');
define('MAIL_SUPPORT_EMAIL', 'support@qfx-markets.com');
define('MAIL_WEBSITE_URL', 'https://qfx-markets.com');

// ================================
// APPLICATION SETTINGS
// ================================
define('APP_NAME', 'QFXMarkets');
define('APP_URL', 'https://client.qfx-markets.com');
define('APP_ENVIRONMENT', 'production');
// ================================


// ================================
// EMAIL AUTOMATION SETTINGS
// ================================
define('EMAIL_AUTOMATION_ENABLED', true);
define('EMAIL_QUEUE_ENABLED', false); // Set to true for high-volume environments
define('EMAIL_LOG_ENABLED', true);
define('EMAIL_DEBUG_MODE', false);

// ================================
// SECURITY SETTINGS
// ================================
define('ENCRYPTION_KEY', 'your-32-character-encryption-key-here');
define('JWT_SECRET', 'your-jwt-secret-key-here');
define('SESSION_TIMEOUT', 3600); // 1 hour

// ================================
// FILE UPLOAD SETTINGS
// ================================
define('UPLOAD_MAX_SIZE', 5242880); // 5MB
define('UPLOAD_ALLOWED_TYPES', ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx']);
define('KYC_UPLOAD_PATH', __DIR__ . '/uploads/kyc/');
define('TRANSACTION_PROOF_PATH', __DIR__ . '/uploads/transactions/');

// ================================
// LOGGING CONFIGURATION
// ================================
define('LOG_PATH', __DIR__ . '/logs/');
define('LOG_LEVEL', 'INFO'); // DEBUG, INFO, WARNING, ERROR
define('LOG_MAX_FILES', 30); // Keep logs for 30 days

// ================================
// BUSINESS LOGIC SETTINGS
// ================================
define('MIN_WITHDRAWAL_AMOUNT', 10);
define('MAX_WITHDRAWAL_AMOUNT', 50000);
define('WITHDRAWAL_PROCESSING_TIME', '1-3 business days');
define('KYC_REQUIRED_FOR_WITHDRAWAL', true);
define('DEFAULT_CURRENCY', 'USD');
define('DEFAULT_LEVERAGE', 100);

// ================================
// NOTIFICATION SETTINGS
// ================================
define('ADMIN_EMAIL', 'admin@ecotradefx.com');
define('ADMIN_NOTIFICATIONS_ENABLED', true);
define('USER_NOTIFICATIONS_ENABLED', true);
define('SMS_NOTIFICATIONS_ENABLED', false);

// ================================
// RATE LIMITING
// ================================
define('API_RATE_LIMIT', 100); // requests per minute
define('EMAIL_RATE_LIMIT', 10); // emails per minute per user

// ================================
// BACKUP AND MAINTENANCE
// ================================
define('BACKUP_ENABLED', true);
define('BACKUP_FREQUENCY', 'daily');
define('MAINTENANCE_MODE', false);

// ================================
// THIRD-PARTY INTEGRATIONS
// ================================
define('PAYMENT_GATEWAY_ENABLED', true);
define('SOCIAL_LOGIN_ENABLED', false);
define('ANALYTICS_ENABLED', true);

// ================================
// UTILITY FUNCTIONS
// ================================

/**
 * Get configuration value with fallback
 */
function getConfig($key, $default = null) {
    return defined($key) ? constant($key) : $default;
}

/**
 * Check if feature is enabled
 */
function isFeatureEnabled($feature) {
    $key = strtoupper($feature) . '_ENABLED';
    return getConfig($key, false);
}

/**
 * Get upload path for specific type
 */
function getUploadPath($type = 'general') {
    switch ($type) {
        case 'kyc':
            return KYC_UPLOAD_PATH;
        case 'transaction':
            return TRANSACTION_PROOF_PATH;
        default:
            return __DIR__ . '/uploads/';
    }
}

/**
 * Log message with timestamp
 */
function logMessage($message, $level = 'INFO', $file = 'application.log') {
    if (!LOG_ENABLED) return;
    
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] [$level] $message" . PHP_EOL;
    
    $logFile = LOG_PATH . $file;
    if (!file_exists(LOG_PATH)) {
        mkdir(LOG_PATH, 0755, true);
    }
    
    file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);
}

// ================================
// ENVIRONMENT-SPECIFIC SETTINGS
// ================================
if (APP_ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    define('LOG_ENABLED', true);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    define('LOG_ENABLED', EMAIL_LOG_ENABLED);
}

// ================================
// CORS HEADERS FOR API
// ================================
function setCorsHeaders() {
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    
    $allowedOrigins = [
        'https://ecotradefx.com',
        'https://admin.ecotradefx.com',
        'http://localhost:3000',
        'http://localhost:3001'
    ];
    
    if (in_array($origin, $allowedOrigins)) {
        header("Access-Control-Allow-Origin: $origin");
        header("Access-Control-Allow-Credentials: true");
    } else {
        header("Access-Control-Allow-Origin: *");
    }
    
    header('Content-Type: application/json');
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
    header('Access-Control-Max-Age: 1728000');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

// ================================
// AUTO-INCLUDE MAIL SYSTEM
// ================================
require_once __DIR__ . '/mail_system/integrated_mail_system.php';

?>